<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>

	<div id="sns_tab_products" class="product-collateral clearfix">
		<ul class="nav-tabs gfont">
			<?php foreach ( $tabs as $key => $tab ) : ?>
				<li class="<?php echo esc_attr( $key ); ?>_tab">
					<a href="#tab-<?php echo esc_attr( $key ); ?>" data-toggle="tab"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?></a>
				</li>
			<?php endforeach; ?>
			<?php if ( is_active_sidebar( 'product-tab-sidebar' ) ) : ?>
				<li class="sns_prod_custom_tab">
					<a href="#tab-sns_prod_custom_tab" data-toggle="tab"><?php echo esc_html__('Custom Tab', 'snssimen'); ?></a>
				</li>
			<?php endif; ?>
		</ul>
		<div class="tab-content">
		<?php foreach ( $tabs as $key => $tab ) : ?>

			<div class="tab-pane fade" id="tab-<?php echo esc_attr( $key ); ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ) ?>
			</div>

		<?php endforeach; ?>
			<?php if ( is_active_sidebar( 'product-tab-sidebar' ) ) : ?>
				<div class="tab-pane fade" id="tab-sns_prod_custom_tab">
					<?php dynamic_sidebar( 'product-tab-sidebar' ); ?>
				</div>
			<?php endif; ?>
		</div>
		<script>
        	jQuery(document).ready(function($){
        		if ( window.location.href.indexOf('#comments') > 0 ) {
        			$('#sns_tab_products .nav-tabs').find("li.reviews_tab").addClass("active");
	        		$('#sns_tab_products .tab-content').find("#tab-reviews").addClass("active in");
        		}else{
	        		$('#sns_tab_products .nav-tabs').find("li").first().addClass("active");
	        		$('#sns_tab_products .tab-content').find(".tab-pane").first().addClass("active in");
	        	}
	        	if($(window).width() < 992){
	        		$('#sns_tab_products .nav-tabs').tabdrop();
	        	}
	       	});
		</script>
		<?php do_action( 'woocommerce_product_after_tabs' ); ?>
	</div>

<?php endif; ?>
